//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Collections.Specialized;

namespace FrameworkLibraries
{
	public class BitVector32Main 
	{
		// Utworzenie masek dla wektora bitowego.
		private static readonly int MaskOne = BitVector32.CreateMask();
		private static readonly int MaskTwo = BitVector32.CreateMask(MaskOne);
		private static readonly int MaskThree = BitVector32.CreateMask(MaskTwo);
		private static readonly int MaskFour = BitVector32.CreateMask(MaskThree);
		private static readonly int MaskFive = BitVector32.CreateMask(MaskFour);
		private static readonly int MaskSix = BitVector32.CreateMask(MaskFive);
		private static readonly int MaskSeven = BitVector32.CreateMask(MaskSix);
		private static readonly int MaskEight = BitVector32.CreateMask(MaskSeven);
		// Utworzenie sekcji dla wektora bitowego.
		private static readonly BitVector32.Section first = 
			BitVector32.CreateSection(15);
		private static readonly BitVector32.Section second = 
			BitVector32.CreateSection(15, first);
 
		static void Main(string [] args)
		{
			BitVector32 bv = new BitVector32();
			bv[MaskEight] = true;
			bv[MaskOne] = true;
			Console.WriteLine("{0}", bv);
			bv = new BitVector32();
			bv[first] = 14;
			bv[second] = 7;
			Console.WriteLine("{0}", bv);
		}
	}
}